﻿Public Class Form1
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.KeyPreview = True
    End Sub
    Private Sub Form1_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles MyBase.KeyPress
        If e.KeyChar = Chr(Keys.Enter) Then
            Me.SelectNextControl(Me.ActiveControl, True, True, True, True)
            e.Handled = True
        End If
    End Sub
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If TextBox1.Text = "" Then
            TextBox1.Focus()
            Return
        End If
        If TextBox2.Text = "" Then
            TextBox2.Focus()
            Return
        End If

        Dim lpix As Decimal = 4  'ラインのピクセル
        Dim tpix As Decimal = 4  '文字のピクセル
        Dim r As Decimal = 60  'Ｒの変数 TextBox1に入力された数値
        Dim fai As Decimal  'Φの変数 TextBox2に入力された数値
        Dim x As Decimal  'Ｘの変数 
        Dim xsent As Decimal = 30  'ｘの端面位置
        Dim ysent As Integer  'yの中心位置
        Dim roux As Decimal  '四捨五入後のｘの値
        Try
            r = TextBox1.Text
        fai = TextBox2.Text
            ysent = TextBox3.Text
            If fai > r * 2 Then
                MsgBox("直径の値はＲの２倍より" & vbNewLine & "小さくなければなりません。")
                Return
            End If
        'xの値を求めるメソッド
        x = xans()

        '各変数のピクセル化
        Dim faip As Decimal = fai * lpix
        Dim rp As Decimal = r * lpix
        Dim xp As Decimal = x * lpix

        Dim xsentp As Decimal = xsent * lpix
        Dim ysentp As Decimal = ysent * lpix

        Dim bmp As New Bitmap(PictureBox1.Size.Width, PictureBox1.Size.Height)
        PictureBox1.Image = bmp
        Dim g As Graphics
        g = Graphics.FromImage(PictureBox1.Image)

        '中心線
        Dim daslin As New Pen(Color.Black, 1)
        daslin.DashStyle = Drawing.Drawing2D.DashStyle.DashDot
        g.DrawLine(daslin, xsentp - 10 * lpix, ysentp, xsentp + 60 * lpix + xp, ysentp)
        'ラインの太さ
        Dim pb1 As New Pen(Color.Black, 1)
        Dim pb2 As New Pen(Color.Black, 2)

        'フォントスタイル
        Dim d As New Font("ＭＳ Ｐゴシック", 12, FontStyle.Bold)
        Dim f As New Font("ＭＳ Ｐゴシック", 20, FontStyle.Bold)

        '図形ライン
        '後端面のライン　　垂直線
        g.DrawLine(pb2, xsentp, ysentp - faip / 2, xsentp, ysentp + faip / 2)
        '外径ライン　　水平線
        g.DrawLine(pb2, xsentp, ysentp - faip / 2, xsentp + 50 * lpix, ysentp - faip / 2)
        g.DrawLine(pb2, xsentp, ysentp + faip / 2, xsentp + 50 * lpix, ysentp + faip / 2)
        'ここから寸法線
        '垂直線
        g.DrawLine(pb2, xsentp + 50 * lpix + xp, ysentp, xsentp + 50 * lpix + xp, ysentp - faip / 2 - 2 * lpix)
        '水平線
        g.DrawLine(pb1, xsentp + 50 * lpix, ysentp - faip / 2, xsentp + 50 * lpix + xp, ysentp - faip / 2)
        '→線
        pb1.CustomStartCap = New Drawing2D.AdjustableArrowCap(3, 8)
        g.DrawLine(pb1, xsentp + 50 * lpix + xp, ysentp - faip / 2, xsentp + 50 * lpix + xp + 10 * lpix, ysentp - faip / 2)

        '先端Ｒのライン
        Dim angl As Decimal
        angl = (Math.Asin(fai / 2 / r)) * (180 / Math.PI)
        g.DrawArc(pb2, xsentp + 50 * lpix + xp - rp * 2, ysentp - rp, rp * 2, rp * 2, 360 - angl, angl * 2)

        '文字の表示
        roux = Math.Round(x, 3, MidpointRounding.AwayFromZero)
            g.DrawString("Ｘの値は　" & roux, f, Brushes.BlueViolet, 40 * lpix + xp, ysentp - faip / 2 - 10 * lpix)
        g.DrawString("Ｘ", d, Brushes.Black, xsentp + 55 * lpix + xp, ysentp - faip / 2 - 5 * lpix)

        f.Dispose()
        g.Dispose()

         Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical)
        End Try

    End Sub
    'xの値を求めるメソッド
    Private Function xans() As Decimal
        Dim r As Decimal    'Ｒの変数 TextBox1に入力された数値
        Dim fai As Decimal  'Φの変数 TextBox2に入力された数値
        Dim x As Decimal
        r = TextBox1.Text
        fai = TextBox2.Text

        x = r - Math.Sqrt(r * r - fai * fai / 4)
        Return x

    End Function
    'リセット
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        PictureBox1.Image = Nothing
        TextBox1.Text = ""
        TextBox2.Text = ""
        TextBox1.Focus()
    End Sub

    Private Sub バージョンToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles バージョンToolStripMenuItem.Click
        MsgBox(Application.ProductVersion & vbNewLine & Application.ProductName)
    End Sub

    Private Sub 制作ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles 制作ToolStripMenuItem.Click
        MsgBox("田中　裕之")
    End Sub

    Private Sub 説明書ToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles 説明書ToolStripMenuItem.Click
        Dim reader As New IO.StreamReader(Application.StartupPath & "\" & "Readme.txt", System.Text.Encoding.GetEncoding("shift-jis"))
        Dim f As New Form2
        Dim x As String
        f.Owner = Me
        x = reader.ReadToEnd
        f.TextBox1.Text = x
        f.Show()
        f.TextBox1.DeselectAll()
    End Sub
End Class
